<?php
namespace Automattic\WooCommerce\Blocks\BlockTypes;

/**
 * SingleProduct class.
 */
class SingleProduct extends AbstractBlock {
	/**
	 * Block name.
	 *
	 * @var string
	 */
	protected $block_name = 'single-product';

	/**
	 * Enqueue frontend assets for this block, just in time for rendering.
	 *
	 * @param array $attributes  Any attributes that currently are available from the block.
	 */
	protected function enqueue_assets( array $attributes ) {
		parent::enqueue_assets( $attributes );
		$product_id = intval( $attributes['productId'] );
		$this->hydrate_from_api( $product_id );
	}

	/**
	 * Get the editor script handle for this block type.
	 *
	 * @param string $key Data to get, or default to everything.
	 * @return array|string;
	 */
	protected function get_block_type_editor_script( $key = null ) {
		$script = [
			'handle'       => 'wc-' . $this->block_name . '-block',
			'path'         => $this->asset_api->get_block_asset_build_path( $this->block_name ),
			'dependencies' => [ 'wc-blocks' ],
		];
		return $key ? $script[ $key ] : $script;
	}

	/**
	 * Hydrate the Single Product block with data from the API.
	 *
	 * @param int $product_id ID of the product.
	 */
	protected function hydrate_from_api( int $product_id ) {
		$this->asset_data_registry->hydrate_api_request( "/wc/store/v1/products/$product_id" );
		$this->asset_data_registry->hydrate_api_request( '/wc/store/v1/cart' );
	}
}
