<?php
/**
 * Title: Product Details Pattern
 * Slug: woocommerce-blocks/product-details-pattern
 * Categories: WooCommerce
 */
?>
<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"0","left":"0"}}}} -->
<div class="wp-block-columns alignwide">
	<!-- wp:column {"style":{"spacing":{"padding":{"top":"0","right":"40px","bottom":"0","left":"0px"},"blockGap":"0px"}}} -->
	<div class="wp-block-column" style="padding-top:0;padding-right:40px;padding-bottom:0;padding-left:0px">
		<!-- wp:image {"id":1,"sizeSlug":"full","linkDestination":"none"} -->
		<figure class="wp-block-image size-full">
			<img src="<?php echo esc_url( plugins_url( 'images/pattern-placeholders/table-floor-home-living-room-furniture-room.png', dirname( __FILE__ ) ) ); ?>" alt="<?php esc_attr_e( 'Placeholder image used to represent a product being showcased in a product details banner. 1 out of 3.', 'woocommerce' ); ?>" class="wp-image-1"/>
		</figure>
		<!-- /wp:image -->

		<!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"0","left":"0"},"padding":{"top":"0","right":"0","bottom":"0","left":"0"},"margin":{"top":"0.2em","bottom":"0.2em"}}}} -->
		<div class="wp-block-columns" style="margin-top:0.2em;margin-bottom:0.2em;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0">
			<!-- wp:column {"style":{"spacing":{"padding":{"top":"0px","right":"5px","bottom":"0px","left":"0px"},"blockGap":"0"}},"layout":{"type":"default"}} -->
			<div class="wp-block-column" style="padding-top:0px;padding-right:5px;padding-bottom:0px;padding-left:0px;">
				<!-- wp:image {"id":1,"sizeSlug":"full","linkDestination":"none"} -->
				<figure class="wp-block-image size-full">
					<img src="<?php echo esc_url( plugins_url( 'images/pattern-placeholders/table-white-chair-floor-shelf-lamp-square-lg.png', dirname( __FILE__ ) ) ); ?>" alt="<?php esc_attr_e( 'Placeholder image used to represent a product being showcased in a product details banner. 2 out of 3.', 'woocommerce' ); ?>" class="wp-image-1"/>
				</figure>
				<!-- /wp:image --></div>
			<!-- /wp:column -->

			<!-- wp:column {"style":{"spacing":{"padding":{"top":"0","right":"0","bottom":"0","left":"0"},"blockGap":"0px"}},"layout":{"type":"default"}} -->
			<div class="wp-block-column" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;">
				<!-- wp:image {"id":1,"sizeSlug":"full","linkDestination":"none"} -->
				<figure class="wp-block-image size-full">
					<img src="<?php echo esc_url( plugins_url( 'images/pattern-placeholders/table-floor-interior-atmosphere-living-room-furniture-square-lg.png', dirname( __FILE__ ) ) ); ?>" alt="<?php esc_attr_e( 'Placeholder image used to represent a product being showcased in a product details banner. 3 out of 3.', 'woocommerce' ); ?>" class="wp-image-1"/>
				</figure>
				<!-- /wp:image --></div>
			<!-- /wp:column --></div>
		<!-- /wp:columns --></div>
	<!-- /wp:column -->

	<!-- wp:column -->
	<div class="wp-block-column">
		<!-- wp:heading {"style":{"color":{"text":"#000000"}},"fontSize":"x-large"} -->
		<h2 class="wp-block-heading has-text-color has-x-large-font-size" style="color:#000000">Luxurious Charcoal Grey Upholstered Sofa</h2>
		<!-- /wp:heading -->

		<!-- wp:group {"style":{"spacing":{"padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px"},"blockGap":"0px","margin":{"top":"10px","bottom":"0px"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
		<div class="wp-block-group" style="margin-top:10px;margin-bottom:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px">
			<!-- wp:paragraph {"style":{"color":{"text":"#fcb900"}}} -->
			<p class="has-text-color" style="color:#fcb900">★★★★</p>
			<!-- /wp:paragraph -->

			<!-- wp:paragraph {"style":{"color":{"text":"#ffe8a4"},"spacing":{"margin":{"right":"5px"}}}} -->
			<p class="has-text-color" style="color:#ffe8a4;margin-right:5px">★</p>
			<!-- /wp:paragraph -->

			<!-- wp:paragraph {"style":{"typography":{"fontSize":"0.7em"},"color":{"text":"#000000"}}} -->
			<p class="has-text-color" style="color:#000000;font-size:0.7em">  <strong>4.2</strong>(1,079 reviews)</p>
			<!-- /wp:paragraph -->
		</div>
		<!-- /wp:group -->

		<!-- wp:group {"style":{"spacing":{"blockGap":"8px","padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px"},"margin":{"top":"2px","bottom":"0px"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
		<div class="wp-block-group" style="margin-top:2px;margin-bottom:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px">
			<!-- wp:paragraph {"style":{"typography":{"fontSize":"1.2em"},"color":{"text":"#000000"}}} -->
			<p class="has-text-color" style="color:#000000;font-size:1.2em"><strong><sup><sub>$</sub></sup>158.99</strong></p>
			<!-- /wp:paragraph -->

			<!-- wp:paragraph {"style":{"typography":{"fontSize":"0.7em"},"layout":{"selfStretch":"fit","flexSize":null},"color":{"text":"#000000"}}} -->
			<p class="has-text-color" style="color:#000000;font-size:0.7em"><s>was $173.99</s></p>
			<!-- /wp:paragraph -->

			<!-- wp:paragraph {"style":{"typography":{"fontSize":"0.7em"},"color":{"text":"#C51313"}}} -->
			<p class="has-text-color" style="color:#C51313;font-size:0.7em"><strong>9% off</strong></p>
			<!-- /wp:paragraph -->
		</div>
		<!-- /wp:group -->

		<!-- wp:group {"style":{"spacing":{"blockGap":"0px","margin":{"top":"5px"}}},"layout":{"type":"constrained"}} -->
		<div class="wp-block-group" style="margin-top:5px">
			<!-- wp:paragraph {"style":{"color":{"text":"#00A510"},"typography":{"fontSize":"0.7em"},"spacing":{"margin":{"top":"0px","right":"0px","bottom":"0px","left":"0px"}}}} -->
			<p class="has-text-color" style="color:#00A510;margin-top:0px;margin-right:0px;margin-bottom:0px;margin-left:0px;font-size:0.7em"><strong>Free 2-Day Shipping</strong></p>
			<!-- /wp:paragraph -->
		</div>
		<!-- /wp:group -->

		<!-- wp:group {"layout":{"type":"constrained","justifyContent":"left"}} -->
		<div class="wp-block-group">
			<!-- wp:paragraph {"style":{"typography":{"fontSize":"0.8em"},"color":{"text":"#000000"}}} -->
			<p class="has-text-color" style="color:#000000;font-size:0.8em">The "Modern Elegance: Luxurious Charcoal Grey Upholstered Sofa" harmonizes style and comfort to redefine your living space. This stunning piece is crafted with plush, high-density foam cushions, enveloped in a rich, charcoal grey fabric that is invitingly soft to the touch. Its clean lines and contemporary silhouette are complemented by the sturdy wooden frame, making it a durable yet stylish addition to any home decor. Whether you're lounging or entertaining, this sofa promises unrivaled comfort and a look that's seamlessly chic.</p>
			<!-- /wp:paragraph -->
		</div>
		<!-- /wp:group -->

		<!-- wp:group {"layout":{"type":"constrained","justifyContent":"left"}} -->
		<div class="wp-block-group">
			<!-- wp:buttons -->
			<div class="wp-block-buttons">
				<!-- wp:button {"style":{"color":{"text":"#ffffff","background":"#000000"}}} -->
				<div class="wp-block-button">
					<a class="wp-block-button__link has-text-color has-background wp-element-button" style="color:#ffffff;background-color:#000000">Add to cart</a>
				</div>
				<!-- /wp:button -->
			</div>
			<!-- /wp:buttons -->
		</div>
		<!-- /wp:group -->

		<!-- wp:group {"layout":{"type":"constrained","justifyContent":"left"}} -->
		<div class="wp-block-group">
			<!-- wp:paragraph {"style":{"typography":{"fontSize":"0.8em"},"color":{"text":"#000000"}}} -->
			<p class="has-text-color" style="color:#000000;font-size:0.8em"><strong>Features</strong></p>
			<!-- /wp:paragraph -->

			<!-- wp:list {"style":{"spacing":{"margin":{"top":"10px","right":"0","bottom":"0","left":"0"}},"color":{"text":"#000000"}}} -->
			<ul class="has-foreground-color has-text-color" style="color:#000000;margin-top:10px;margin-right:0;margin-bottom:0;margin-left:0">
				<!-- wp:list-item {"style":{"typography":{"fontSize":"0.8em"}}} -->
				<li style="font-size:0.8em">Top shelf weight capacity of 100 lbs</li>
				<!-- /wp:list-item -->

				<!-- wp:list-item {"style":{"typography":{"fontSize":"0.8em"}}} -->
				<li style="font-size:0.8em">Drawer weight capacity of 50 lbs</li>
			<!-- /wp:list-item --></ul>
			<!-- /wp:list --></div>
		<!-- /wp:group -->

		<!-- wp:group {"layout":{"type":"constrained","justifyContent":"left"}} -->
		<div class="wp-block-group">
			<!-- wp:paragraph {"style":{"typography":{"fontSize":"0.8em"},"color":{"text":"#000000"}}} -->
			<p class="has-text-color" style="color:#000000;font-size:0.8em"><strong>Weight and Dimensions</strong></p>
			<!-- /wp:paragraph -->

			<!-- wp:table {"style":{"typography":{"fontSize":"0.7em"},"color":{"text":"#000000"}},"backgroundColor":"background","className":"is-style-stripes"} -->
			<figure class="wp-block-table is-style-stripes" style="font-size:0.7em">
				<table class="has-background-background-color has-text-color has-background" style="color:#000000">
					<tbody>
						<tr><td>Overall</td><td>36.5'' H X 40'' W X 20'' D</td></tr>
						<tr><td>Drawer Interior</td><td>2'' H X 29.25'' W X 12.5'' D</td></tr>
						<tr><td>Countertop</td><td>40'' W X 20'' D</td></tr>
						<tr><td>Countertop Thickness</td><td>0.7'' H</td></tr>
						<tr><td>Overall Product Weight</td><td>39.6 lb.</td></tr>
					</tbody>
				</table>
			</figure>
			<!-- /wp:table --></div>
		<!-- /wp:group --></div>
	<!-- /wp:column --></div>
<!-- /wp:columns -->
